//=============================================================================
// 02messageXY.js
//=============================================================================

/*:ja
 * @plugindesc 変数でメッセージウィンドウのX軸、Y軸を移動させます。変数番号はプラグインパラメータで指定できます。
 * @author ツクマテの人々
 *
 * @param xVariableId
 * @text X軸変数ID
 * @desc メッセージウィンドウのX軸を移動させる変数IDを指定します。
 * @type variable
 * @default 13
 *
 * @param yVariableId
 * @text Y軸変数ID
 * @desc メッセージウィンドウのY軸を移動させる変数IDを指定します。
 * @type variable
 * @default 14
 *
 * @help このプラグインには、プラグインコマンドはありません。
 */

(function () {
  'use strict';

  // プラグインパラメータの取得
  const parameters = PluginManager.parameters('02messageXY');
  const xVariableId = Number(parameters['xVariableId'] || 13);  // X軸変数ID（デフォルトは13）
  const yVariableId = Number(parameters['yVariableId'] || 14);  // Y軸変数ID（デフォルトは14）

  // メッセージウィンドウの位置更新
  const _Window_Message_updatePlacement = Window_Message.prototype.updatePlacement;
  Window_Message.prototype.updatePlacement = function () {
    _Window_Message_updatePlacement.call(this);
    this.x += $gameVariables.value(xVariableId);  // プラグインパラメータで指定したX軸変数ID
    this.y += $gameVariables.value(yVariableId);  // プラグインパラメータで指定したY軸変数ID
  };
})();
